/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.config.gui.entry;

import com.misterpemodder.shulkerboxtooltip.impl.config.gui.ConfigCategoryTab;
import com.misterpemodder.shulkerboxtooltip.impl.config.gui.entry.ConfigEntry;
import com.misterpemodder.shulkerboxtooltip.impl.tree.ValueConfigNode;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class ValueConfigEntry<C, T, V>
extends ConfigEntry {
    private final class_2561 label;
    private final class_2561 labelChanged;
    private final class_2561 labelError;
    private final class_2561 labelErrorChanged;
    @Nullable
    private final List<class_5481> tooltip;
    private List<class_5481> tooltipWithError;
    protected final ConfigCategoryTab<C> tab;
    protected final List<class_339> children = Lists.newArrayList();
    protected final ValueConfigNode<C, T, V> valueNode;
    public final class_4185 resetButton;
    public final class_4185 undoButton;
    @Nullable
    private class_2561 validationError;
    private boolean hasChanged;
    public static final class_2561 RESET_BUTTON_LABEL = class_2561.method_43471((String)"shulkerboxtooltip.config.reset_to_default.small");
    public static final class_2561 RESET_BUTTON_TOOLTIP = class_2561.method_43471((String)"shulkerboxtooltip.config.reset_to_default.full");
    public static final class_2561 UNDO_BUTTON_LABEL = class_2561.method_43471((String)"shulkerboxtooltip.config.undo.small");
    public static final class_2561 UNDO_BUTTON_TOOLTIP = class_2561.method_43471((String)"shulkerboxtooltip.config.undo.full");

    protected ValueConfigEntry(ConfigCategoryTab<C> tab, ValueConfigNode<C, T, V> valueNode) {
        this.tab = tab;
        this.label = valueNode.getTitle().method_27661().method_27692(class_124.field_1080);
        this.labelChanged = this.label.method_27661().method_27695(new class_124[]{class_124.field_1056, class_124.field_1068});
        this.labelError = this.label.method_27661().method_27692(class_124.field_1061);
        this.labelErrorChanged = this.label.method_27661().method_27695(new class_124[]{class_124.field_1056, class_124.field_1061});
        this.tooltip = valueNode.getTooltip() == null ? null : tab.getMinecraft().field_1772.method_1728((class_5348)valueNode.getTooltip(), 350);
        this.tooltipWithError = this.getTooltipWithError();
        this.valueNode = valueNode;
        this.resetButton = class_4185.method_46430((class_2561)RESET_BUTTON_LABEL, b -> this.resetToDefault()).method_46434(0, 0, Math.max(tab.getMinecraft().field_1772.method_27525((class_5348)RESET_BUTTON_LABEL) + 6, 20), 20).method_46431();
        this.resetButton.field_22763 = !valueNode.isDefaultValue(this.tab.getConfig());
        this.children.add((class_339)this.resetButton);
        this.undoButton = class_4185.method_46430((class_2561)UNDO_BUTTON_LABEL, b -> this.resetToActive()).method_46434(0, 0, Math.max(tab.getMinecraft().field_1772.method_27525((class_5348)UNDO_BUTTON_LABEL) + 6, 20), 20).method_46431();
        this.undoButton.field_22763 = !valueNode.isActiveValue(this.tab.getConfig());
        this.children.add((class_339)this.undoButton);
    }

    public void resetToDefault() {
        this.valueNode.resetToDefault();
        this.tab.getScreen().refresh();
    }

    public void resetToActive() {
        this.valueNode.resetToActive(this.tab.getConfig());
        this.tab.getScreen().refresh();
    }

    public V getValue() {
        return this.valueNode.getEditingValue(this.tab.getConfig());
    }

    public void setValue(V value) {
        this.valueNode.setEditingValue(value);
        this.tab.getScreen().refresh();
    }

    @Override
    public void refresh() {
        this.resetButton.field_22763 = !this.valueNode.isDefaultValue(this.tab.getConfig());
        this.undoButton.field_22763 = !this.valueNode.isActiveValue(this.tab.getConfig());
        this.validationError = this.valueNode.validate(this.tab.getConfig());
        this.hasChanged = !this.valueNode.isActiveValue(this.tab.getConfig());
        this.tooltipWithError = this.getTooltipWithError();
    }

    @NotNull
    public List<? extends class_364> method_25396() {
        return this.children;
    }

    @NotNull
    public List<? extends class_6379> method_37025() {
        return this.children;
    }

    @Override
    @Nullable
    public List<class_5481> getTooltip() {
        return this.validationError != null ? this.tooltipWithError : this.tooltip;
    }

    private List<class_5481> getTooltipWithError() {
        if (this.validationError != null) {
            ArrayList<class_5481> errorTooltip = new ArrayList<class_5481>();
            if (this.tooltip != null) {
                errorTooltip.addAll(this.tooltip);
            }
            errorTooltip.add(this.validationError.method_27661().method_27692(class_124.field_1061).method_30937());
            return errorTooltip;
        }
        return this.tooltip;
    }

    protected void renderLabel(class_332 guiGraphics) {
        class_2561 l;
        int x = this.method_73380();
        int y = this.method_73382();
        if (this.validationError != null) {
            l = this.hasChanged ? this.labelErrorChanged : this.labelError;
        } else {
            class_2561 class_25612 = l = this.hasChanged ? this.labelChanged : this.label;
        }
        if (this.tab.getMinecraft().field_1772.method_1726()) {
            x = x + this.method_73387() - this.tab.getMinecraft().field_1772.method_27525((class_5348)l);
        }
        guiGraphics.method_51430(this.tab.getMinecraft().field_1772, l.method_30937(), x, y + 5, -1, false);
    }
}

